using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_PM25CalculationD : ucBase
    {
        public uc_PM25CalculationD()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_PM25CalculationD_Load(object sender, EventArgs e)
        {
            try
            {
                pnlRequiredDV.Visible = false;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSelect_Click(object sender, EventArgs e)
        {
            try
            {
                pnlRequiredDV.Visible = true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                string strDV = "";
                StringBuilder builder = new StringBuilder();
                this.pnlRequiredDV.Visible = false;
                for (int i = 0; i < this.clboRequiredDV.Items.Count; i++)
                {
                    if (this.clboRequiredDV.GetItemChecked(i))
                    {
                        builder.Append(clboRequiredDV.Items[i].ToString() + ",");
                    }
                }
                strDV = builder.ToString();
                if (strDV == "" || strDV == null)
                {
                    strDV = "None selected";
                }
                else
                {
                    strDV = strDV.Substring(0, strDV.Length - 1);
                }
                txtRequiredDVD.Text = strDV;
                if (txtRequiredDVD.Text !=" None selected")
                {
                    if (Convert.ToInt32(txtRequiredDVD.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearD.Text)
                        || Convert.ToInt32(txtRequiredDVD.Text.Remove(0, txtRequiredDVD.Text.Length - 4)) > Convert.ToInt32(cboEndYearD.Text))
                        MessageBox.Show(LanguageOld.Translate("Required Design Values is not correct!"));
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblMonitorDataYears_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_6_pm2_5_calculation_option.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblValidFRMMonitors_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_6_pm2_5_calculation_option.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboStartYearD_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearD.Text) < Convert.ToInt32(cboStartYearD.Text))
                    cboEndYearD.Text = cboStartYearD.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearD_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearD.Text) < Convert.ToInt32(cboStartYearD.Text))
                    cboStartYearD.Text = cboEndYearD.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
